# Setting the Scientific Stage for Esports Psychology: A Systematic

# Review

Ismael Pedraza-Ramirez1\* , Lisa Musculus1 , Markus Raab1,3 , Sylvain Laborde1,2,

1 Department of Performance Psychology, Institute of Psychology, German Sport University Cologne, Cologne, Germany

2 University of Caen Normandy, UFR STAPS, EA 4260, France

3 School of Applied Science, London South Bank University, UK

\* Corresponding author. German Sport University Cologne, Institute of Psychology, Department of Performance Psychology, Am Sportpark Müngersdorf 6, 50933 Cologne, Germany.

14 Email Address: i.pedraza@stud.dshs-koeln.de

# Setting the Scientific Stage for Esports Psychology: A Systematic

# Review

Competitive gaming, better known as electronic sports (esports), is rapidly growing in popularity. We systematically reviewed the available literature regarding the psychological aspects of esports using the Preferred Reporting Items for Systematic Review and Meta-Analysis Protocols (PRISMA-P) evidence-based reporting checklist and a Population, Intervention, Comparator, and Outcomes (PICO) framework with the following inclusion criteria: (i) published between 1994 and 2018; (ii) empirical investigation (as the current state of research is dense with positions and opinions but has few empirical investigations); and (iii) focussed on esports games that are associated with either cognitive performance or game performance. The goal of our research was twofold: to present a summary of the empirical evidence addressing the psychological characteristics of both cognitive and game performance in esports, and to integrate esports in the field of sport psychology. More specifically, our goals were to highlight the interplay of psychological aspects of performance and esports and to clearly define the theoretical foundations of the psychological aspects of esports performance. Underlining the differences from video gaming will inform future research directions and stimulate the development of high-quality practice in the applied field of sports and exercise psychology.

Keywords: esports; cognition; performance; sport psychology; game performance

# Introduction

Historically, competitive video gaming tournaments started in 1972 at Stanford University with the game Spacewar (Li, 2016), but the pioneer of professional tournaments is the Cyberathlete Professional League, which started in 1997 (Goodale, 2003). These tournaments represent the first step towards establishing a professional electronic sports (esports) culture. The first recognition by a professional sports governing body took place in South Korea in 2000 when the Korea e-Sports Association was founded as part of the Ministry of Culture, Sports, and Tourism (Korea e-Sports Association, 2014). By the 2010s, esports had experienced a rapid rise, as teams and professional tournaments were founded and broadcasts became common (Popper, 2013; Tassi, 2012).

Even though the professional growth of esports as a performance environment continues, this is in clear contrast to the development of scientific knowledge on the factors involved in high-level esports performance (Campbell, Toth, Moran, Kowal, & Exton, 2018). For instance, there is increasing scientific research on video games (Anderson et al., 2010; Reeves, Brown, & Laurier, 2009; Witkowski, 2012; Yee, 2006), but not specifically on esports, where so far, the research is rather qualitative and exploratory (Hallmann & Giel, 2018). Hence, there is a need for experimental research on esports (Murphy, 2009), starting with a clear differentiation of the prerequisites of video game and esports performance (Dale & Green, 2017).

Overall, the role of psychological factors in esports is still poorly understood. To address this, we systematically reviewed the esports literature with two main aims: first, to systematically summarize the available literature on esports related to both cognitive and game performance, and second, to integrate esports in the field of sports psychology, more specifically, highlighting the role of psychological aspects of

performance in esports. Our analysis is based on the building blocks of performance conceptualized in sports psychology (e.g., emotion, motivation, perception, action, and cognition; Raab, Lobinger, Hoffmann, Pizzera, & Laborde, 2015).

# Transition From Video Games to Esports

Previous research on video games categorised many video games as action video games (Dale & Green, 2017; see Table 1) based on key characteristics of the game, for example, aiming, shooting, and running (Bediou et al., 2018), despite the games being in accepted genres of their own, for instance, first-person shooters (FPSs; e.g., CounterStrike1 ), multiplayer online battle arenas (MOBAs; e.g., League of Legends; LoL), realtime strategy games (e.g., StarCraft), sports games (e.g., FIFA), or fighting games (e.g., Marvel vs. Capcom). Other well-known video game genres include role-playing games (RPGs), simulations, and puzzle games (Lemmens & Hendriks, 2016). Most of the genres and the video games within them share similar characteristics (e.g., within MOBA: LoL and Dota).

However, the transition of video games from recreational and unstructured use has evolved into a highly competitive domain that is now called professional esports. This evolution is changing not only how the video games' community interacts but also the way how empirical evidence is obtained in this field (Tang, 2018). For examples, researchers who have studied the effects of video games on cognition acknowledged that the effects found so far could be uncertain if the individual characteristics and the constant evolution of each video game and gamers is not considered (Dale & Green, 2017; Momi et al., 2018).

Consequently, one can see how over the years, the development of professional esports has positioned teams and players within a performance context, facilitating the initial understanding of psychological factors underlying esports expertise (Campbell et al., 2018; Himmelstein, Liu, & Shapiro, 2017; Pedraza-Ramirez, 2019).

# [Table 1 near here]

# Resolving the definitional dilemma in esports

It is important to mention that there is still a diverse number of spellings and definitions for esports. Therefore, we decided to address and contribute in this matter, aiming to concur in the terminology for future works.

First, we have decided to use the Associated Press’s spelling of the competitive video gaming industry (Esports or eSports?, 2017): esports. Second, there are several definitions of the term, which still lack specificity. For example, esports has been defined as the form of competitive videogame playing against other players in person or online, playing for trophies or points, and playing for speed (i.e., competing for the fastest completion time in a game; Ruvalcaba, Shulze, Kim, Berzenski, & Otten, 2018, p. 296). Additionally, Hamari and Sjöblom (2017, p. 213) defined esports as ‘a form of sports where the primary aspects of the sport are facilitated by electronic systems; the input of players and teams as well as the output of the eSports system are mediated by human-computer interfaces’. Even though this definition highlights the term ‘sports’, it can be debated whether esports require the same physical exertion as mainstream sports, such as football, tennis, or basketball. Additionally, according to the Council of Europe (2001), the word ‘sports’ refers to ‘all forms of physical activity which, through casual or organised participation, aim at expressing or improving physical fitness and mental well-being, forming social relationships or obtaining results in competition at all levels’. However, we would argue that the physical exertion (i.e., energy expenditure, physical effort) in esports during competition and as part of participants’ training can indeed be considered similar to that in other activities such as archery, shooting, bridge, or chess (Schwarz, Schächinger, Adler, & Goetz, 2003; Troubat, Fargeas-Gluck, Tulppo, & Dugué, 2009), which are all recognized as sports by the International Olympic Committee.

Taking into account the different existing perspectives and the characteristics of esports, we propose the following definition that clearly differentiates esports from video gaming:

Esports is the casual or organized competitive activity of playing specific video games that provide professional and/or personal development to the player. This practice is facilitated by electronic systems, either computers, consoles, tablets, or mobile phones, on which teams and individual players practice and compete online and/or in local-area-network tournaments at the professional or amateur level. The games are established by ranking systems and competitions and are regulated by official leagues. This structure provides players a sense of being part of a community and facilitates mastering expertise in fine-motor coordination and perceptual-cognitive skills, particularly but not exclusively, at higher levels of performance.

So, according to our definition, not every video game is an esports game but every esports game is a video game. Video games such as Super Mario Bros., The Sims, or Grand Theft Auto can be played casually, and in some cases, there are organized tournaments. But these types of games do not have ranking systems, and competitions regulated by official leagues.

# The Psychology of Esports Performance

In sports psychology, researchers work to understand the underlying mechanisms of performance in different competitive domains (Ericsson, Krampe, & Tesch-Römer, 1993) within the sports context (e.g., Côté, Baker, & Abernethy, 2007;

Starkes & Ericsson, 2003). Accordingly, Murphy (2009) suggested that the physical (motor) and cognitive skills development that occurs when engaging in competitive video games could be of interest to sports psychologists. Consequently, we suggest that esports is an ideal domain for studying performance, and that this domain should be integrated in the research and applied field of sports psychology. In this review, we use cognitive and in-game performance measures to conceptually define and quantify esports performance.

High-level performance has received much attention in applied and research sports psychology, with research groups, journals (Sport, Exercise, and Performance Psychology), and books (e.g., Performance Psychology by Raab et al., 2015) devoted to the topic. Performance can be seen everywhere, and it is often used as an umbrella term to explain behaviour associated with the achievement of goals (Raab et al., 2015). Thus, esports performance, similar to physical sports performance, is an end outcome achieved across time that can be measured in different ways (e.g., winning or acquiring gold, being ranked, etc.). From a philosophical perspective, Nitsch and Hackfort (2015) addressed the importance of understanding the psychology of performance from two different angles: First, performance can be seen as the realization of a performance action driven by the motivation and interests of the person, that is, ‘performance as a means to an end’ (p. 13); second, performance can be seen as the realization and perfection of that performance action in itself, that is, ‘performance as an end in itself’ (p. 13). A competitive esports player requires the cognitive processes needed to meet the demands of the game (e.g., decision making, attention, and memory; Raab et al., 2015; Voss, Kramer, Basak, Prakash, & Roberts, 2010) and in-game skills (e.g., finemotor coordination, game knowledge, etc.), which Donaldson (2017, p. 427) called ‘mechanical expertise’.

# Cognitive Performance in Esports

In the domain of sports, cognitive performance has been studied from two theoretical perspectives. Some have focussed on experts’ performance, in particular on sport-specific cognitive processes (Musculus, Ruggeri, Raab, & Lobinger, 2019; Raab, Masters, & Maxwell, 2005; Voss et al., 2010), and others have taken a more general approach, focussing on cognitive processes that are common to all sports (Voss et al., 2010). In esports, the majority of studies have so far focussed instead on esports-general cognitive processes (e.g., Seya & Shinoda, 2016). Given this lack of specificity in studies of the cognitive processes of certain video games (Bediou et al., 2018; Green & Bavelier, 2015), the cognitive processes underlying performance in esports are still unclear. The characteristics of the environment in which esports take place may offer improved ecological validity over laboratory-based research on traditional sports when exploring specific cognitive processes (Pluss et al., 2019). Yet, it is of utmost importance to determine if there is already empirical work testing cognitive processes in laboratory settings that could shed light on esports cognitive performance.

# Game Performance in Esports

As in any other sports domain, the evaluation of game performance is fundamental to understanding progress and the attainability of desired outcomes. Usually in sports, such assessments are based on statistical and outcome parameters (Tenenbaum & Filho, 2016). In esports, it is possible to measure performance on the basis of results (i.e., win/lose) and in-game statistics (e.g., amount of gold acquired per minute, number of kills, deaths, assists [known in the games as KDA], points, etc.; Bertran & Chamarro, 2016) or other indicators such as positioning in league rankings or points. However, these game performance measures vary depending on the game. Multiplayer Online Battle Arena games have a very similar structure, and thus similar outcome measures (e.g., gold per minute, KDA, etc.) can be used. Similarly, FPS games use some of the MOBA game performance measures, such as kills, and deaths (KD) (Parshakov, Coates, & Zavertiaeva, 2018). However, it is important to acknowledge that even though esports can provide many different statistical measures coming directly from the games, these measures are still too unexplored and unreliable to lead to an understanding of the underlying cognitive processes on their own, so other measures of performance are still needed. Accordingly, we would like to consider these in-game performance outcomes as esports performance.

# Previous Reviews and Meta-Analyses of Esports

Esports is a growing industry, and as yet, few theoretical models of the fundamental mechanisms of competitive performance have been developed. Although there are still not enough empirical studies to compare effect sizes in the field of esports, there are a few published meta-analyses of video game research and cognitive abilities. For example, Bediou and colleagues (2018) focussed on the impact of action video games on cognition. Medium effect sizes were found in cross-sectional studies of habitual action video game play, whereas in intervention studies a small to medium effect size was found in a few cognitive domains. Overall, Bediou and colleagues (2018) suggest that those who regularly play action video games display better cognitive processes than those who play little or none. Additionally, authors, concluded that the positive enhancements in cognition do not equally impact all cognitive functions. Thus, the cognitive processes associated with working memory and inhibitory control within perception, spatial cognition and top-down attention seem to show considerable promises in both the theoretical and practical understanding of action video games and cognition.

In another meta-analysis, Sala, Tatlidil, and Gobet (2017) concluded that video game training does not enhance cognitive abilities. The overall results showed, first, weak correlations between skill and cognitive abilities; second, small differences in the cognitive abilities between players and non-players; and third, no or insignificant effects between a video game training group and a control group. These findings do not support the theories of far transfer of video game training and cognitive training. However, there is the need of advanced experimental designs that allow us to better understand any far transfer effects or specific cognitive processes that are important for specific video games. In contrast, Wang and colleagues (2016) aimed to assess the effects of action video game training on cognitive abilities. They found moderate to small effect sizes in overall and specific cognitive improvement in healthy adults. Especially, improvements were shown in cognitive processes related to inhibitory control, such as visuospatial and attention processing. Similarly, a study testing the impact of video games on information processing (Powers, Brooks, Aldrich, Palladino, & Alfieri, 2013) found that in true experiments, video game training had a significant (small) effect on inhibition, whereas quasi-experimental studies showed moderate effects for dual/multitasking and switching, and small effects for inhibition, intelligence, and working/short-term memory. Even though the results from the quasi-experimental studies showed higher impact of action video game training on the four cognitive functions (e.g., working memory, inhibitory control, cognitive flexibility, and higher order), it is suggested that specific cognitive processes are closely related to the cognitive demands of the game used.

The above discussed results shed light on the importance to consider separately the cognitive demands of each video game to better understand the specific cognitive processes that could be more or less impacted by video game training.

Although the findings of these meta-analyses contribute to the understanding of the cognitive effects of video games in general, methodological limitations (publication bias, small effect sizes, and conceptual issues across different meta-analytic comparisons) have been acknowledged (Bediou et al., 2018). When considering esports, even if it is too soon to discuss the effects of training, the evidence from the metaanalyses in video games seems promising to understand key cognitive processes such as perception, spatial cognition, attention, intelligence and dual/multitasking in specific games that require high cognitive load (e.g., LoL, CS:GO, StarCraft, etc.).

Moreover, there are three important literature reviews that have highlighted the need to develop scientific knowledge on the psychological and cognitive concepts of esports.

Bányai, Griffiths, Király, and Demetrovics (2019) explored the relationship between esports and psychology. Eight studies were included and categorised into three main topics: (1) becoming an esport player, (2) the characteristics of esport players, and (3) the motivations of esport spectators. The authors concluded that the path of becoming an esport player is similar to that of a professional athlete in physical sports (e.g., training, preparation, mental skills, and obstacles). Furthermore, the authors argued that professional video gamers and professional gamblers have similarities, such as excessive time spent playing. Consequently, the authors suggested that future research should consider these similarities and focus on esport players’ psychological vulnerability.

Garcia-Naveira, Toribio, Molero, and Suarez (2018) reviewed 26 articles on the cognitive and psychological benefits of video games and esports. They concluded that the regular practice of video games and esports stimulates specific brain structures and benefits the development of cognitive processes (e.g., intelligence, working memory, decision making, cognitive flexibility, etc.). Also, this practice was found to positively influence psychological skills such as motivation, self-regulation, self-confidence, and social skills. The authors acknowledged the need to study video games and esports separately, yet they included both in their review.

Lastly, Mora-Cantallops and Sicilia (2018) explored player behaviour in MOBA games, mainly focussing on two esports, LoL and Dota 2. This review restricted the search to articles on MOBA games published since 2011. The authors found 23 studies attempting to understand the behaviour and motivation of players, describe social interactions in the online world, and gain knowledge of game play and outcomes using computer modelling, topological measures, and spatio-temporal behaviours of the teams. The review concluded that researchers should cooperate with professional players to better understand tactical and strategy of the games to be able to combine traditional research approaches like survey and interviews with innovative computer science techniques.

Although Bányai et al.'s (2019) summary of the qualitative research on esports players is appreciated, our contribution is aimed at looking into only the quantitative evidence in relation to esports and performance. Additionally, whereas Garcia-Naveira et al. (2018) looked only at the research on the benefits of video games in general since 2012, we undertook a more specific exploration of both the cognitive and in-game outcomes of playing, and, as suggested by Garcia-Naveira et al. (2018), we included not only esports that were developed shortly before or after the ‘boom’ in esports in 2010 (e.g., LoL; Dota 2) but also those that have been around much longer, such as Tetris since 1984. Thus, we were not limited by the databases’ (see Information sources, below) maximum range (1994–2018) but could also include studies identified through other sources published before or after that range, in contrast to both Garcia-Naveira et al. (2018) and Mora-Cantallops and Sicilia (2018). Although they followed specific social science guidelines for systematic reviews (Petticrew & Roberts, 2008), MoraCantallops and Sicilia (2018) explored a wide range of topics not necessarily related to esports performance. We have focussed on integrating esports performance in sports psychology and have also followed the Preferred Reporting Items for Systematic Review and Meta-Analysis Protocols (PRISMA-P) guidelines and the Population, Intervention, Comparator, and Outcomes (PICO) study design model for reporting systematic reviews and meta-analyses (Liberati et al., 2009; Shamseer et al., 2015).

# The Current Systematic Review

Our systematic review yielded the added value of clarifying and highlighting relevant factors of cognitive and in-game performance in specific esports that have been previously studied in general video game research without considering the relationship of competition and performance in esports. Additionally, we provide a heuristic model to illustrate the current state of the art, suggesting that future research should test the bidirectional influence of all factors related to esports performance.

# Methods

# Eligibility Criteria

Studies were selected according to the PICO criteria (Table 2). The literature search covered the period of January 1994 (the earliest date allowed in one of the databases) to October 2018 (the point at which we conducted our search). Since one of the databases limited the period of our search (i.e., no earlier than 1994) and we wanted to include all relevant publications, we were slightly flexible and included records identified through other sources (see Information sources) that were published before or after that range. To ensure quality, our selection criteria were publications in a peer-reviewed journal and being written in either English or Spanish.

# [Table 2 near here]

# Information Sources

The literature search was conducted in the electronic databases Web of Science, Science Direct, and EBSCOhost. The latter allowed us to narrow the search to the most relevant databases for our interest (SPORTDiscus, PSYNDEX, and SocINDEX). Additionally, the reference lists from all selected papers and the respective citations of each study from the time of publication up to the date of our search were hand searched. Even though we did not include unpublished studies (e.g., conference posters and abstracts, theses, etc.), books, or position papers in or analysis, the reference lists from those sources as well as reviews and meta-analyses were checked and considered to establish the state of the art.

# Search Strategy

We searched for only quantitative studies, using terms combined with different expressions (esports OR e-sports OR electronic gaming OR competitive gaming OR online gaming OR professional video gaming) AND (psychology OR cognition OR psychological skills OR performance OR neural basis). The combination of such terms was applied in each of the databases (i.e., Web of Science, Science Direct, and EBSCOhost).

# Study Records

# Data Management

The first phase of the literature search involved exporting the results (title/abstract) to a Word document to determine which studies were potentially relevant to our systematic review. The first author screened the titles and abstracts to remove any that did not meet our inclusion criteria, after which the selected studies were uploaded to the reference manager software Mendeley to check for duplicates. The results were exported to an Excel spreadsheet, where the articles were numbered. Subsequently, the titles and abstracts went through a second phase consisting of extracting initial information from each article in the Excel spreadsheet (e.g., study title, author, year, journal, the aim of the study, etc.) while verifying once more whether the article met the selection criteria.

# Data Collection Processes

Using the Excel spreadsheet, the first author extracted data that included demographic information, design information, performance measures, the aim of the study, the intervention details, and the outcomes. Each study that was included in the final pool and any whose inclusion was unclear after the selection criteria assessment were discussed in a team meeting, by at least two more authors, until consensus was reached. Figure 1 shows a flow diagram of the selection process, following the PRISMA-P methodology. Fifty-two studies were included for final analysis.

# Data Items

Some studies considered for inclusion focussed on specific esports but others on many different video games, so we considered only those studies that clearly addressed esports. Also, some focussed on either one or both performance outcomes (i.e., game performance and cognitive performance). Therefore, we extracted the specific measures used. Lastly, we conducted a search on the journal names to get a better understanding of where the initial research on esports performance has been published.

# Outcomes and Prioritization

The main outcomes of our review were (1) the types of esports video games analysed in the studies, which were dependent on our esports definition, and (2) esports performance outcomes: (a) the performance on cognitive tasks (cognitive processes

tested in a laboratory setting or controlled environment) and (b) the game performance measures coming from the games themselves (e.g., winning/losing, KDA, gold per minute, etc.).

# Risk of Bias in Individual Studies

Risk of bias within the included studies was assessed by two of the authors using the Joanna Briggs Institute Critical Appraisal Checklist for Analytical Cross Sectional studies (Moola et al., 2017). This tool contains eight risk-of-bias questions to determine the extent to which the selected studies addressed the possibility of bias in their design, running, and analysis. Using validated definitions, each item was answered with yes, no, unclear, or not applicable (see Appendix A).

# Results

# Study Description

The $N = 5 2$ publications that met the inclusion criteria (see Figure 1) were published between 1992 and 2019. The studies were published in many different journals $( N = 4 0 )$ ). PLoS ONE, with six, published the most, and four were published in Computers in Human Behavior. For the cognitive science journals, Applied Cognitive Psychology published four and Topics in Cognitive Science three. The majority of studies ${ } n = 3 5$ ) were the only publications on the topic in the respective journal (e.g., Nature, Proceedings of the National Academy of Science of the United States of America, etc.; see Appendix B). The studies were divided into the two main categories of esports performance: (a) cognitive performance and (b) game performance. An extra category was created for studies combining the two measures. The main findings of the systematic review are presented in Table 3 for cognitive performance and Table 4 for game performance. Overall, $2 5 \%$ ${ \mathit { n } } = 1 3$ ) of the research on esports performance targeted only cognitive performance, $4 6 . 2 \%$ ${ n = 2 4 }$ ) targeted only game performance, and $2 8 . 8 \%$ $( n = 1 5 )$ ) reported both of these characteristics.

[Tables 3 and 4 near here]

The publications exploring the cognitive performance of esports $n = 2 8$ ) were of an experimental $( n = 1 1 $ ), quasi-experimental ${ ( n = 1 4 ) }$ ), cross-sectional $( n = 1 )$ ), quasiexperimental and cross-sectional $( n = 1 )$ ), or longitudinal $( n = 1$ ) design. These publications were divided by the different cognitive functions they assessed (Diamond, 2013; Miyake et al., 2000): (a) working memory $( n = 8 )$ ), (b) inhibitory control $( n = 2 )$ , (c) cognitive flexibility $( n = 2 )$ ), (d) higher order functions, and any combination of two or more ( ${ \it n } = 1 6$ ; Table 3). The publications on game performance $( n = 3 9$ ) were of an experimental $( n = 1 4 )$ ), quasi-experimental $( n = 6 )$ ), cross-sectional $( n = 1 3$ ), longitudinal $( n = 3 )$ ), experimental and cross-sectional $( n = 1 )$ ), quasi-experimental and crosssectional $( n = 1 )$ ), or cross-sectional and longitudinal $( n = 1 )$ ) design. These publications were divided into two main categories that enabled us to differentiate the purpose of the studies (following Nitsch & Hackfort, 2015): (a) expertise differences (i.e., esports performance as a means to an end; $n = 2 0$ ) and (b) effects of esports participation/training (i.e., esports performance as an end in itself; $n = 1 9$ ; Table 4).

# Cognitive Performance

The studies measuring cognitive performance used a great variety of cognitive tasks to understand the link between esports and cognitive functions (e.g., Boot, Kramer, Simons, Fabiani, & Gratton, 2008; Kokkinakis, Cowling, Drachen, & Wade, 2017; Table 3). For example, the most frequent cognitive tasks used by authors to assess working memory were mental rotation tasks $( n = 6 )$ ) and the operation span task $( n = 6 )$ ; inhibitory control was investigated with the useful field of view $( n = 4 )$ ) and multiple object tracking $( n = 4 )$ ) tasks, cognitive flexibility with task-switching paradigms $( n = 3$ ), and higher order functions with Raven’s matrices $( n = 3 )$ ) and the Wechsler Abbreviated

Scale of Intelligence $( n = 2 )$ .

# Working Memory

Overall, mixed effects were reported regarding the relationship between esports training and working memory. That is, positive effects of training/participation were found in working memory tasks such as spatial resolution and mental rotation in Unreal Tournament, Tetris, CoD, and CS:GO (C.S. Green & Bavelier, 2007; Lau-Zhu, Holmes, Butterfield, & Holmes, 2017; Momi et al., 2018; Okagaki & Frensch, 1994; Seya & Shinoda, 2016; Terlecki, Newcombe, & Little, 2008), but some counter-evidence exists of the effects of esports training in working memory tasks in Dota 2 and Tetris (Boot et al., 2008; Pilegard & Mayer, 2018; Röhlcke, Bäcklund, Sörman, & Jonsson, 2018). In terms of expertise differences, researchers found that expert LoL, Dota, StarCraft, Guilty Gear, CoD, Halo, and Battlefield players outperformed amateur players in spatial and visual working memory tasks (Chang, Liu, Chen, & Hsieh, 2017; Gong et al., 2016; C.S. Green & Bavelier, 2006; Kowalczyk et al., 2018; Pereira, Wilwert, & Takase, 2016; Seya & Shinoda, 2016; Tanaka et al., 2013). Additionally, studies found higher activation of the brain network structure associated with spatial and visual processing of the working memory functions in expert Guilty Gear, LoL, Dota, and StarCraft players in comparison to non-expert players (Gong et al., 2016; Kowalczyk et al., 2018; Tanaka et al., 2013). In sum, although there are exceptions, positive effects of training and expertise differences on working memory have been observed in a great variety of esports.

Inhibitory Control

In terms of inhibitory control, positive effects of esports training were found in LoL, Unreal Tournament, CoD, Halo, Counter-Strike, Gears of War, and Tetris players in comparison to non-players on visual selective attention and multiple-object tracking tasks (Bavelier, Achtman, Mani, & Föcker, 2012; Bejjanki et al., 2014; Ding et al., 2018; C.S. Green & Bavelier, 2006; Qiu et al., 2018). Additionally, brain networks associated with inhibitory control, in expert LoL, Dota 2, and FIFA 15 players showed enhanced functional integration between salience and central executive networks of the brain and stronger activation in comparison to non-experts (Aliyari et al., 2015; Ding et al., 2018; Gong et al., 2016). Furthermore, Halo, Counter-Strike, Gears of War, and CoD players had faster reaction times and presented lower activity in the frontoparietal network that mediates attention location in comparison to non-players (Bavelier et al., 2012). Overall, positive effects of esports training on inhibitory control processes were found in different types of esports, especially in those that require fast reaction times, such as Counter-Strike and CoD, but also those in which strategy and planning are highly important, such as LoL and Dota 2.

# Cognitive Flexibility

Overall, only a few studies have explored the relationship between esports training or expertise and cognitive flexibility (e.g., Glass, Maddox, & Love, 2013; Hyun et al., 2013; Klaffehn, Schwarz, Kunde, & Pfister, 2018). The main findings were found in StarCraft I and II for long-term engagement and training. Researchers found an increased volume of the prefrontal cortex and positive significant correlations of training and performance on cognitive flexibility tasks (Glass et al., 2013; Hyun et al., 2013). However, in a study with many different types of esports, Klaffehn et al. (2018) found that Age of Empires, LoL, Dota, StarCraft II, Battlefield, CS:GO, CoD, and Counter-Strike players did not show higher task-switching performance in comparison to non-players.

# Higher Order Functions

Mixed evidence has been reported regarding the relation between esports and higher order functions. Esports training and practice in expert and non-expert Unreal Tournament, CoD, Tetris, and LoL players were found to be associated with an improvement in fluid intelligence and higher order function tasks (Bejjanki et al., 2014; Kokkinakis et al., 2017; Lau-Zhu et al., 2017). Conversely, other studies of Dota 2 and Tetris players found experience had no effect on fluid intelligence (Boot et al., 2008; Röhlcke et al., 2018).

# Game Performance

Thirty-nine studies investigated expertise variables of in-game performance or the effects of esports participation or training by using specific in-game variables (e.g., results, KDA, and ranking) to observe game-playing effects or to measure engagement (e.g., Boot et al., 2008; Breuer, Scharkow, & Quandt, 2013; C.S. Green & Bavelier, 2007; Huang, Yan, Cheung, Nagappan, & Zimmermann, 2017; Table 4).

# Expertise Differences in Esports Performance

Several studies reported that expert LoL and Tetris players were faster and more accurate in decision-making situations and better than non-experts at performing under high pressure, as measured via biosignals of the autonomic nervous system (e.g., heart rate variability, and respiration rate; Ding et al., 2018; Lindstedt & Gray, 2019; Maglio, Wenger, & Copeland, 2008). Furthermore, during a simulated tournament, higher cortisol levels were found for high-ranked Unreal Tournament players immediately before and after a winning match (Oxford, Ponzi, & Geary, 2010). Conversely, measures of game experience and performance in LoL players were unrelated to hormone changes (e.g., cortisol, testosterone, etc.) between playing against humans

compared to playing against machine (i.e., artificial intelligence) (Gray, Vuong, Zava, & McHale, 2018).

Additionally, expert Dota 2 and StarCraft II players were found to be   
significantly better than non-experts at in-game tasks such as mini-map recall, players allocate more time to look at certain regions of the map such as HP/Mana and Shop Button, extrapolating information with one fixation, distinctive use of Hotkey Selects (i.e., keys combination; shortcuts) and the levels of Action Latency (i.e., interval between action and response) (Bonny & Castaneda, 2016; Castaneda, Sidhu, Azose, & Swanson, 2016; Thompson, Blair, Chen, & Henrey, 2013). In Tetris, novice players’ ability to place the Zoids (i.e., blocks) seemed to show a lack of the perceptual-motor skills involved in planning and decision making, a difference from experts who are more engaged in the game strategy process (Sibert, Gray, & Lindstedt, 2017).   
Mixed evidence has so far been reported regarding the effects of age and amount of practice on expertise. In terms of the amount of practice, authors have found on the one hand that the number of games played in Dota 2 is a strong predictor of expertise (Röhlcke et al., 2018). On the other hand, in LoL, researchers have reported a weak relationship of the number of games played and expertise (Kokkinakis et al., 2017). In regard to the relationship of age and expertise, authors have suggested that there is a cognitive-motor decline in StarCraft II players associated with age that seems to begin around 24 years (Thompson, Blair, & Henrey, 2014). Also, it has been suggested that in Destiny, Battlefield, LoL, and Dota 2, peak performance is experienced at around 22–27 years old (Kokkinakis et al., 2017). However, findings have shown that performance in Battlefield 3 peaks around the age of 20 and that older players show weaker   
performance and offset this deficiency by practicing more (Tekofsky, Spronck,   
Goudbeek, Plaat, & van den Herik, 2015; Thompson et al., 2014). These mixed results

show that the expertise differences attributable to age and amount of practice should be considered and researched individually for better clarification, as they may be unique to each esport.

In terms of practice and learning styles, establishing consistent habits and forming routines were found to be important characteristics of expert Halo, StarCraft II, and LoL players. Research showed that the most effective strategy to improve players’ skills included both playing a moderate number of matches and taking short breaks (Huang et al., 2017; Sapienza, Zeng, Bessi, Lerman, & Ferrara, 2018). Furthermore, Destiny and LoL players who more regularly chose to play with self-selected teammates tended to have higher game performance than those who decided to play with random teammates (Kahn & Williams, 2016; Pirker, Rattinger, Drachen, & Sifa, 2018). Sapienza et al. (2018) also found that individual and team performance in LoL can be affected by the presence of friends on a team. At the team level, authors have identified specific characteristics of successful teams. For example, Xia, Wang, and Zhou (2017) found in Dota 2 that the frequencies of kills by one player, kills by multiple players, initiation of fights, and activation of runes were significantly higher on the winning teams than on the losing teams. Additionally, it was found that the successful teams in LoL were those that showed the highest scores on the Transactive Memory System Scale, which measures a group’s ability to learn, remember, and communicate knowledge relevant to the group (i.e., shared knowledge; Kahn & Williams, 2016). Moreover, Wang, Yang, and Sun (2015) found that those teams that possessed at least one player with a global-liberal playing style, that is, a player who assisted teammates (i.e., collaborative style), had significantly higher win rates than teams without this type of player.

# Effects of Esports Participation/Training

Several psychosocial characteristics of participation and training in esports have been shown to affect performance. For example, looking into the cooperative and competitive aspects of FIFA, Dota 2, and LoL players’ style, researchers found that players’ behaviour, attitudes towards winning and losing, and harmonic and obsessive passion had significant effects on affect and performance (Bertran & Chamarro, 2016; Breuer et al., 2013; Hudson & Cairns, 2016). In regards to the effects of motives for participating in Dota 2, improvement in solo matches (i.e., no predetermined teams) suggests that skill improvement or the sense of personal achievement were primary motivators for playing (Bonny & Castaneda, 2017). Furthermore, exploring CS:GO and WoW participation, studies showed gender and game performance interactions as a predictor of enjoyment, with women deriving enjoyment from discovering the games, while men were more interested in the competition aspect of the games (Billieux et al., 2013; Hopp & Fisher, 2017). Another esports characteristic, the presence of an audience, was shown to decrease players’ performance while playing Tetris (Kimble & Rezabek, 1992). However, a positive association between audience presence and improved performance was discovered for the game Quake (Bowman, Weber, Tamborini, & Sherry, 2013). Finally, in Doom, Tafalla (2007) found positive effects of playing with the in-game sound on performance.

# Discussion

Beginning in the early 1990s and for almost 30 years since (see Appendix C), researchers have been exploring the psychosocial aspects of competition and cognitive processes in esports. The early works acknowledged that certain video games could facilitate a deeper understanding of human performance. However, it took almost 20 years, from the first study in 1992 until 2010, for 10 studies related to the performance of what we now call esports to be published. Finally, from 2011 to the beginning of 2019, an additional 42 studies were published on esports performance. This systematic review of 52 articles, following the PRISMA-P guidelines, presents the available evidence regarding the psychological aspects of esports performance.

# Cognitive Performance in Esports

The mixed effects found for esports training on working memory tasks might have been due to differences in the methodological designs and aims of the studies, with low sample size and the inclusion of many different cognitive tasks possibly affecting the results. The effects of expertise on working memory tasks are in line with the positive effects of esports training and the demands that strategy and FPS esports make in terms of holding and monitoring information. Furthermore, the higher levels of expertise in esports (e.g., LoL, Dota 2, Counter-Strike, etc.) and the activation of the brain networks associated with inhibitory control processes show the importance of information processing for game performance. Although we encourage to understand the specific individual cognitive demands for each esports, it is necessary to acknowledge that there will be an overlap when referring to cognitive functions. For instance, working memory and inhibitory control generally need one another, especially in complex esports such as LoL, StarCraft, and Counter-Strike where there is a vast amount of information available from opponents, teammates, and the game environment. Consequently, players need to assess what information is relevant for their goal, hold it using their working memory capacity, and determine what to inhibit to make favourable decisions.

Despite the mixed evidence found between cognitive flexibility processes and esports, the research is promising to understanding the cognitive demands of changing perspectives and adapting to new information in specific esports. The constant changes in esports like LoL (e.g., creation of new avatars, skills, rules, etc.) force players to find ways to adapt and keep up with those changes, which means structure training methodologies and learning styles are important during this process.

Fluid intelligence positively correlates with experience in LoL players (Kokkinakis et al., 2017), but not in players of the similar game, Dota (Röhlcke et al., 2018). Consequently, these results indicate, first, the importance of considering the uniqueness of each esports (e.g., frequency of game updates) and how this could be associated with specific cognitive demands on players. Second, one must consider the methodological designs of these two studies, which might explain the contrasting results: Röhlcke et al.’s (2018) study that found no effects was not carried out in a controlled environment, which could have affected the reliability of the results. Furthermore, improvements in performance found after Unreal Tournament and CoD training (Bejjanki et al., 2014) might suggest that higher-order functions are related to the more unpredictable and cognitively demanding type of esports.

Overall, researchers have started to recognize that different esports require different cognitive processes and motor abilities. Consequently, esports research and sports psychologists will benefit from understanding the underlying cognitive mechanisms of each esports, in order to adapt training strategies to the specificities of each game. For example, some esports are very stable in the way they need to be played across years or months, while in other esports, very specific characteristics can change every 2 weeks (e.g., LoL) and players are required to adjust, adapt, and learn the new demands of the game, which may require higher levels of cognitive flexibility and higher order functions (e.g., fluid intelligence, decision making, etc.) to achieve peak performance. Brain imaging and psychophysiological tools will facilitate this understanding of cognitive processes and possible predictors of performance among players due to the ecological validity that esports can provide.

Even though we agree that there is increasing empirical evidence of the relationship between playing esports and improved cognitive performance, the mixed evidence and methodological limitations cannot be ignored (e.g., Boot et al., 2008; Klaffehn et al., 2018). Consequently, it is necessary to consider the potential confounding variables of the studies included in this review that could affect the reliability of the results, such as the learning curves of participants (Röhlcke et al., 2018; Tekofsky et al., 2015) that varied according to gender and age (Terlecki et al., 2008; Thompson et al., 2014). Thus, we recommend that esports researchers change the methodology of their research to move away from exploring video games as a genre (e.g., action video games, FPS, MOBA, real-time strategy, etc.) and more towards considering individual esports. For instance, although soccer, basketball, American football, and rugby share many similar characteristics, they are individually quite distinct sports. Consequently, while the overall findings on cognitive performance are promising, they reveal that the way forward is to consider the methodological design issues: A more controlled design of the experiments should be considered that takes into account, for example, individual differences, gender, gaming experience, playing frequency, and nature of the game (Boot et al., 2008; Dale & Green, 2017; Klaffehn et al., 2018). This will lead to a better understanding of task transferability in esports training as well as the cognitive functions underlying performance in each esports.

# Game Performance in Esports

The results of our game performance analysis provide several takeaways related to expertise differences and the effects of taking part in esports. First, the findings highlight specific player characteristics that are important when differentiating expertise, particularly in LoL and Tetris, such as fast and accurate decision making and performing under pressure (e.g., Ding et al., 2018; Gray et al., 2018). These characteristics are particularly important when players are competing at the highest levels, where different types of pressure (e.g., time, prizes, expectations, audience, etc.) are present and could define outcomes. Second, results show that there are specific psychological and in-game skills that players can develop to achieve higher levels of performance. Skill development, in particular, seems to be an area where sports psychologists could help in the development of expertise in esports players, particularly as relates to deliberate practice (Ericsson et al., 1993). For instance, in LoL, a performance decline occurs when playing sessions are too long (Sapienza et al., 2018), but experienced players showed fewer performance declines over the course of a session than newer players. Supporting this idea, Halo players showed that less intense and frequent training can result in skill development, but breaks that are too long result in a loss of skill (Huang et al., 2017). Coaches and players can benefit from this crucial information to optimise their training programs according to the characteristics of each esports. Since players experience different performance peaks and declines depending on the esports. For example, StarCraft player suffers from performance declines starting at around 24 years of age (Thompson et al., 2014), in LoL and Dota performance peaks are experienced between 22 and 27 years of age (Kokkinakis et al., 2017), and in Battlefield, a shooting game, peaks are seen at an earlier age: 20 years old (Tekofsky et al., 2015). It is important (a) to consider how players are practicing to improve their skills and (b) to understand the requirements and characteristics of each esport, as, for example, in shooting games more reaction time and attention are needed than in strategy games, where extracting information, planning, and decision making may be more important. In terms of skill acquisition, results are promising, as they show it is possible to implement training models that aid the development of players.

Psychosocial characteristics in esports have been considered to understand how participation or training is related to player behaviour, motivation, affect, and performance. Thus, coaches need to adapt their training methodologies to fulfil players psychological needs, considering the differences in the effects of cooperation and competition concerning gender seen in CS:GO and WoW. Also, in Dota 2 the sense of personal achievement and skill improvement were primary motivators to play (Bonny & Castaneda, 2017). Additionally, the impact of winning and losing in WoW (Hudson & Cairns, 2016) and the psychological characteristic of harmonic and obsessive passion in LoL (Bertran & Chamarro, 2016) show the influence of fulfilling the psychological needs of autonomy, competence and relatedness in relation with future game results. This may be an area where sports psychologists can offer interventions tailored to specific players and the competitive characteristics of esports. Thus, acknowledging the impact of social-cognitive and affective behaviour on esports players could facilitate learning and the optimisation of performance (Wulf & Lewthwaite, 2016). Given previous findings, future studies should consider an appropriate methodological design that acknowledges specific variables that can alter performance, such as considering randomised and blinded experiments, gender and age differences, game history, and the so-called hybrid games (i.e., games with shared characteristics of two or more genres; Dale & Green, 2017). Similarly, authors have suggested that some games share identical characteristics across genres (e.g., FPS, MOBA, etc.), but some have unique elements that need to be considered individually (e.g., CS:GO; Dale & Green, 2017; Momi et al., 2018). Also, the biosocial influence of competition has to be considered, as playing against the artificial intelligence of the game (i.e., bots) is not the same as playing against humans.

It is necessary to better understand expertise and the performance indicators in esports that could support this developmental process. Consequently, having set the scientific stage for esports psychology, first, future investigations should consider recent appeared papers that may be relevant for the development of esports and its alignment with sport psychology (e.g., Gong, Ma, Liu, Yan, & Yao, 2019; Maciej, Kosakowski, & Kaczmarek, 2020; Thompson, McColeman, Blair, & Henrey, 2019). Second, investigations should test the bidirectional influence of the factors related to esports performance and the strength of their influence and should explore those factors that are theoretically plausible but empirically not yet tested. Such as the interplay of high order functions like decision making and affect to understand expertise differences in esports performance. Thus, we provide a heuristic model to illustrate the current state of the art (see Figure 2).

# [Figure 2 near here]

# Conclusion

The present systematic review highlights that research in esports could greatly benefit from a closer alignment to the field of sports psychology, leading to a better understanding of the underlying mechanisms of performance, especially by focussing on cognitive functions and game performance. By integrating the two disciplines, each can help the other overcome theoretical and methodological constraints. For example, esports as a field of research can help efforts to reveal cognitive processes involved in performance and understand individual development and can serve as a domain for the use of neurophysiological markers. This review provides a starting point for future research endeavours, because it is the first systematic review following the PRISMA-P guidelines that explores and separates the empirical evidence on general video games (from their inception) from evidence on esports. Although the research in this field is promising, much work remains. Therefore, to promote the development of research on esports performance we offer our list of the top 10 challenges esports performance research will likely face in the future.

# Top 10 Future Challenges of the Psychology of Esports Performance

(1) Implementing rigorous methodological designs: The research in esports needs to acknowledge the experimental design constraints, already addressed by video game researchers (Dale & Green, 2017), and implement appropriate methodological designs, for instance, avoiding grouping games according to genres, using randomised and blinded experimental designs, and implementing the appropriate statistical power. Also, there is a need to consider homogeneous sample issues (i.e., females and males) and to apply a rigorous criterion for age and video game experience, given the influential differences in cognitive and skill development.

(2) Acknowledging the impact of cognition in esports performance: As shown in this review, different esports rely on different cognitive functions and at times the cognitive requirements are unclear. Thus, it is important to understand (a) how cognitive demands change across different esports and how specific cognitive functions could be more relevant for specific games, (b) what specific esports measures could be defined to understand performance, and (c) the contribution of the building blocks of psychology, that is, perception, memory, emotion, and cognition, to esports performance (Raab et al., 2015).

(3) Identifying performance indicators: Any esports offers a great range of statistical variables that could be connected to player performance. However, these variables can be misinterpreted, generating incorrect information related to performance. Therefore, it is necessary to understand (a) how game performance

characteristics change across games, and (b) what reliable data or performance measures will lead to an accurate understanding of esports expertise. For instance, in sports expertise, differences have been revealed by the decision making of athletes (Musculus, 2018). Additionally, in auto racing, Formula 1 drivers are known for using telemetry information to optimise the performance of the car; using telemetry in esports (see Thompson et al., 2017) could be an interesting way to understand the great number of parameters that can potentially provide performance indicators of esports, ultimately improving esports players’ and coaches’ cognitive and motor processes for competition. (4) Building expertise in esports: In sports, deliberate practice has been used to help players systematically optimise improvement and achieve higher levels of expertise (Ericsson, 2019). However, esports is still working on finding reliable systems that help players and coaches improve performance (Green, 2018). Therefore, a big challenge will be to provide adequate tools and structures to help players and coaches learn and improve performance. One example could be to apply the principles of motor learning theory (OPTIMAL; Wulf & Lewthwaite, 2016), in which performance and learning are thought to be influenced by positive motivational and attentional focus. This approach enables players with a safe environment for satisfaction of the psychological need for competence, establishing situations for choice and a sense of autonomy, which aims to provide feedback that focusses on an external focus of attention, and contributes to enhancing expectancies for success. (5) Defining career development of esports players: The current route to

excellence in esports is still unclear. So, there are no developmental stages defined or real career plans (Abbott & Collins, 2004). Thus, one of the roles of sports psychology in esports should be to facilitate (a) the identification of players’ career paths, and (b) the adaptation and transferability of skills during different transition stages that esports may have (e.g., leagues, countries, different esports, retirement, etc.). This support can facilitate talent development and proper institutionalization of esports as a performance domain.

(6) Addressing the needs of coaches and coaching development: The proper creation of training models that coaches can implement or adapt to their daily practices supports talent development. However, before that, understanding how esports skill acquisition and development work is necessary. Also, educating coaches on how to coach is crucial. Thus, establishing esports coaching courses could be a good first step. Supporting and developing places where coaches could develop themselves, such as in academy teams, could facilitate developmental processes at the professional level where the performance pressure is higher. Providing more opportunities for research and applied sports psychology would help sustain the healthy evolution of esports (Cottrell, McMillen, & Harris, 2018). Thus, the requirement of certification for coaches and managers should be implemented in the future.

(7) Stopping opportunistic esports enhancement tools: The development of lucrative opportunistic tools will be likely to increase in the applied field. For example, the large number of publications in low-quality journals and the amount of grey literature in esports is rapidly expanding. Also, the development of cognitive training devices to improve performance has earned a bad reputation. While it is very useful to understand the foundations of esports performance and use innovative tools, it is necessary to avoid the support of unreliable non-scientific knowledge. Thus, there is a need for more quality

research to develop a better understanding of cognitive training in sports (as suggested by Walton, Keegan, Martin, & Hallock, 2018).

(8) Integrating machine learning models: Motor learning is an important internal process in the development and retention of skills in sports. This is characterised by a set of stages in which cognition is highly relevant to determining appropriate strategies that influence learning processes (e.g., mental practice, observational learning; Schmidt, Lee, Winstein, Wulf, & Zelaznik, 1999). In esports, the proper understanding and use of algorithms and statistical models for performance could greatly advance the development of psychological and cognitive tools that can positively impact performance and training methodologies and facilitate the comprehension of the cognitive and motor behaviour of esports expertise (Lindstedt & Gray, 2019). However, suitable comprehension and multidisciplinary collaboration are essential to make good use of technological advances.

(9) Developing knowledge from biological markers: The high ecological validity of the esports setting for neurophysiological research of performance is undeniable. Consequently, developing an understanding of the psychophysiological and neuropsychological aspects of esports players is an appealing avenue of research for the scientist (Campbell et al., 2018; Murphy, 2009). Thus, future research on biological markers should be carried out. Understanding the interplay of cognitive and behavioural performance in esports could be facilitated by studies on, for instance, hormone responses and heart rate variability and by making use of brain stimulation techniques, eye tracking, and brain activation measures such as electroencephalography and functional magnetic resonance imaging.

0) Understanding the impact of a rapidly changing esports system: Esports is evolving into a high-performance environment where coaches and players are required to implement appropriate structures and models to achieve higher levels of performance (Pedraza-Ramirez, 2019). This continuous evolution could be a challenge in its own right from a research and applied sports psychology perspective (Cottrell et al., 2018; Steinkuehler, 2019). Even though the introduction of expert knowledge from traditional sports into esports is required to develop sustainable performance, there have been a few cases where this introduction has failed (Green, 2018). Consequently, understanding the specific cultural characteristics of each esport itself is necessary to contribute to the transfer of expert knowledge to esports systems.

# Acknowledgements

We thank the Performance Psychology group for their critical feedback on an earlier draft of this manuscript. We thank Anita Todd for English editing. Also, we would like to thank the participants of the discussion session at the FEPSAC Congress in Münster (July 15–20, 2019), who provided valuable remarks for the improvement of the manuscript. No potential conflict of interest is reported by the authors. This work was supported by the German Academic Exchange Service [DAAD] under grant [blinded for peer review].

# References

References marked with an asterisk indicate studies included in this systematic review.

Abbott, A., & Collins, D. (2004). Eliminating the dichotomy between theory and practice in talent identification and development: Considering the role of psychology. Journal of Sport Science, 22(5), 395–408. https://doi.org/10.1080/02640410410001 675324   
\*Aliyari, H., Kazemi, M., Tekieh, E., Salehi, M., Sahraei, H., Daliri, M. R., … Aghdam, A. R. (2015). The effects of Fifa 2015 computer games on changes in cognitive, hormonal and brain waves functions of young men volunteers. Basic and Clinical Neuroscience, 6(3), 193–201.   
Anderson, C. A., Shibuya, A., Ihori, N., Swing, E. L., Bushman, B. J., Sakamoto, A., … Saleem, M. (2010). Violent video game effects on aggression, empathy, and prosocial behavior in Eastern and Western countries: A meta-analytic review. Psychological Bulletin, 136(2), 151–173. https://doi.org/10.1037/a0018251   
Bányai, F., Griffiths, M. D., Király, O., & Demetrovics, Z. (2019). The psychology of esports: A systematic literature review. Journal of Gambling Studies, 35(2), 351– 365. https://doi.org/10.1007/s10899-018-9763-1   
\*Bavelier, D., Achtman, R., Mani, M., & Föcker, J. (2012). Neural bases of selective attention in action video game players. Vision Research, 61, 132–143. https://doi.org/10.1016/j.visres.2011.08.007   
Bediou, B., Adams, D. M., Mayer, R. E., Tipton, E., Green, C. S., & Bavelier, D. (2018). Meta-analysis of action video game impact on perceptual, attentional, and cognitive skills. Psychological Bulletin, 144(1), 77–110. https://doi.org/10.1037/bul0000130   
\*Bejjanki, V. R., Zhang, R., Li, R., Pouget, A., Green, C. S., Lu, Z.-L., & Bavelier, D.

(2014). Action video game play facilitates the development of better perceptual templates. Proceedings of the National Academy of Sciences of the United States of America, 111(47), 16961–16966. https://doi.org/10.1073/pnas.1417056111

\*Bertran, E., & Chamarro, A. (2016). Videogamers of League of Legends: The role of passion in abusive use and in performance. Adicciones, 28(1), 28–34. https://doi.org/10.20882/adicciones.787

\*Billieux, J., Van der Linden, M., Achab, S., Khazaal, Y., Paraskevopoulos, L., Zullino, D., & Thorens, G. (2013). Why do you play World of Warcraft? An in-depth exploration of self-reported motivations to play online and in-game behaviours in the virtual world of Azeroth. Computers in Human Behavior, 29(1), 103–109. https://doi.org/10.1016/j.chb.2012.07.021

\*Bonny, J., & Castaneda, L. (2016). Impact of the arrangement of game information on recall performance of multiplayer online battle arena players. Applied Cognitive Psychology, 30(5), 664–671. https://doi.org/10.1002/acp.3234

\*Bonny, J., & Castaneda, L. (2017). Number processing ability is connected to longitudinal changes in multiplayer online battle arena skill. Computers in Human Behavior, 66, 377–387. https://doi.org/10.1016/j.chb.2016.10.005

\*Boot, W. R., Kramer, A. F., Simons, D. J., Fabiani, M., & Gratton, G. (2008). The effects of video game playing on attention, memory, and executive control. Acta Psychologica, 129(3), 387–398. https://doi.org/10.1016/j.actpsy.2008.09.005 \*Bowman, N. D., Weber, R., Tamborini, R., & Sherry, J. (2013). Facilitating game play: How others affect performance at and enjoyment of video games. Media Psychology, 16(1), 39–64. https://doi.org/10.1080/15213269.2012.742360

\*Breuer, J., Scharkow, M., & Quandt, T. (2013). Sore losers? A reexamination of the frustration–aggression hypothesis for colocated video game play. Psychology of

Popular Media Culture, 4(2), 126–137. https://doi.org/10.1037/ppm0000020

Campbell, M. J., Toth, A. J., Moran, A. P., Kowal, M., & Exton, C. (2018). eSports: A new window on neurocognitive expertise? In S. Marcora & M. Sarkar (Eds.), Sport and the brain: The science of preparing, enduring, and winning, part $C$ (Progress in Brain Research, Vol. 240, pp. 161–174). Cambridge, MA: Academic Press. https://doi.org/10.1016/bs.pbr.2018.09.006

\*Castaneda, L., Sidhu, M. K., Azose, J. J., & Swanson, T. (2016). Game play differences by expertise level in Dota 2, a complex multiplayer video game. International Journal of Gaming and Computer-Media Simulations, 8(4), 1–24. https://doi.org/10.4018/IJGCMS.2016100101

\*Chang, Y.-H., Liu, D.-C., Chen, Y.-Q., & Hsieh, S. (2017). The relationship between online game experience and multitasking ability in a virtual environment. Applied Cognitive Psychology, 31(6), 653–661. https://doi.org/10.1002/acp.3368

Cote, J., Baker, J., & Abernethy, B. (2007). Practice and play in the development of sport expertise. In G Tenenbaum & R. Eklund (Eds.), Handbook of sport psychology (3rd ed., pp. 184–202). Hoboken, NJ: Wiley. https://doi.org/10.1002/9781118270011.ch8

Cottrell, C., McMillen, N., & Harris, B. S. (2018). Sport psychology in a virtual world: Considerations for practitioners working in eSports. Journal of Sport Psychology in Action, 10, 73–81. https://doi.org/10.1080/21520704.2018.1518280

Council of Europe. (2001). Recommendation No. R (92) 13 REV of the committee of ministers to member states on the revised European sports charter. Retrieved from https://rm.coe.int/16804c9dbb

Dale, G., & Green, C. S. (2017). The changing face of video games and video gamers: Future directions in the scientific study of video game play and cognitive

performance. Journal of Cognitive Enhancement, 1(3), 280–294. https://doi.org/10.1007/s41465-017-0015-6

Diamond, A. (2013). Executive functions. Annual Review of Psychology, 64, 135–168. https://doi.org/10.1146/annurev-psych-113011-143750

\*Ding, Y., Hu, X., Li, J., Ye, J., Wang, F., & Zhang, D. (2018). What makes a champion: The behavioral and neural correlates of expertise in multiplayer online battle arena games. International Journal of Human-Computer Interaction, 34(8), 682–694. https://doi.org/10.1080/10447318.2018.1461761

Donaldson, S. (2017). Mechanics and metagame: Exploring binary expertise in League of Legends. Games and Culture, 12(5), 426–444. https://doi.org/10.1177/1555412015590063

Ericsson, A., Krampe, R., & Tesch-Römer, C. (1993). The role of deliberate practice in the acquisition of expert performance. Psychological Review, 100(3), 363–406. https://doi.org/10.1016/j.coi.2013.02.008

Ericsson, K. A. (2019). Towards a science of the acquisition of expert performance in sports: Clarifying the differences betweem deliberate practice and other types of practice. Journal of Sports Sciences, 12, 1-18. https://doi.org/10.1080/02640414.1019.1688618

Esports or eSports? The Associated Press puts an end to the popular debate. (2017). Retrieved from https://www.dexerto.com/news/esports-esports-associated-pressputs-end-popular-debate/32233

Garcia-Naveira, Toribio, M., Molero, B., & Suarez, A. (2018). Beneficios cognitivos, psicológicos y personales del uso de los videojuegos y esports: Una revisión. Revista de Psicología Aplicada Al Deporte y Al Ejercicio Físico, 3, 1–15. https://doi.org/10.5093/rpadef2017a1

\*Glass, B. D., Maddox, W. T., & Love, B. C. (2013). Real-time strategy game training: Emergence of a cognitive flexibility trait. PLoS ONE, 8(8), 1-7. https://doi.org/10.1371/journal.pone.0070350

\*Gong, D., He, H., Ma, W., Liu, D., Huang, M., Dong, L., … Yao, D. (2016). Functional integration between salience and central executive networks: A role for action video game experience. Neural Plasticity, 2016. https://doi.org/10.1155/2016/9803165

Gong, D., Ma, W., Liu, T., Yan, Y., & Yao, D. (2019). Electronic-Sports Experience Related to Functional Enhancement in Central Executive and Default Mode Areas. Neural Plasticity, 2019, 1–7. https://doi.org/10.1155/2019/1940123

Goodale, G. (2003). Are video games a sport? Retrieved from https://www.csmonitor.com/2003/0808/p13s01-alsp.html?entryBottomStory \*Gray, P. B., Vuong, J., Zava, D. T., & McHale, T. S. (2018). Testing men’s hormone responses to playing League of Legends: No changes in testosterone, cortisol, DHEA or androstenedione but decreases in aldosterone. Computers in Human Behavior, 83, 230–234. https://doi.org/10.1016/j.chb.2018.02.004

\*Green, C. S., & Bavelier, D. (2003). Action video game modifies visual selective attention. Nature, 423, 534–537. https://doi.org/10.1038/nature01647

\*Green, C. S., & Bavelier, D. (2006). Enumeration versus multiple object tracking: The case of action video game players. Cognition, 101(1), 217–245. https://doi.org/10.1016/j.cognition.2005.10.004

\*Green, C. S., & Bavelier, D. (2007). Action-video-game experience alters the spatial resolution of vision. Psychological Science, 18(1), 88–94. https://doi.org/10.1111/j.1467-9280.2007.01853.x

Green, C. S., & Bavelier, D. (2015). Action video game training for cognitive enhancement. Current Opinion in Behavioral Sciences, 4, 103–108. https://doi.org/10.1016/j.cobeha.2015.04.012

Green, W. (2018). Sport management & sport psychology for esport: Winning championships. Retrieved from https://medium.com/@MindGamesWeldon/sportmanagement-sport-psychology-for-esport-winning-championships-717491ba4609

Hallmann, K., & Giel, T. (2018). eSports—Competitive sports or recreational activity? Sport Management Review, 21(1), 14–20. https://doi.org/10.1016/j.smr.2017.07.011

Hamari, J., & Sjöblom, M. (2017). What is eSports and why do people watch it? Internet Research, 27(2), 211–232. https://doi.org/10.1108/IntR-04-2016-0085

Himmelstein, D., Liu, Y., & Shapiro, J. L. (2017). An exploration of mental skills among competitive League of Legend players. International Journal of Gaming and Computer-Mediated Simulations, 9(2), 1–21. https://doi.org/10.4018/IJGCMS.2017040101

\*Hopp, T., & Fisher, J. (2017). Examination of the relationship between gender, performance, and enjoyment of a first-person shooter game. Simulation & Gaming, 48(3), 338–362. https://doi.org/10.1177/1046878117693397

\*Huang, J., Yan, E., Cheung, G., Nagappan, N., & Zimmermann, T. (2017). Master maker: Understanding gaming skill through practice and habit from gameplay behavior. Topics in Cognitive Science, 9(2), 437–466. https://doi.org/10.1111/tops.12251

\*Hubert-Wallander, B., Green, C. S., Sugarman, M., & Bavelier, D. (2011). Changes in search rate but not in the dynamics of exogenous attention in action videogame players. Attention, Perception and Psychophysics, 73(8), 2399–2412. https://doi.org/10.3758/s13414-011-0194-7

\*Hudson, M., & Cairns, P. (2016). The effects of winning and losing on social presence in team-based digital games. Computers in Human Behavior, 60, 1–12. https://doi.org/10.1016/j.chb.2016.02.001

\*Hyun, G. J., Shin, Y. W., Kim, B.-N., Cheong, J. H., Jin, S. N., & Han, D. H. (2013). Increased cortical thickness in professional on-line gamers. Psychiatry Investigation, 10(4), 388–392. https://doi.org/10.4306/pi.2013.10.4.388

\*Kahn, A. S., & Williams, D. (2016). We’re all in this (game) together: Transactive memory systems, social presence, and team structure in multiplayer online battle arenas. Communication Research, 43(4), 487–517. https://doi.org/10.1177/0093650215617504

\*Kimble, C. E., & Rezabek, J. S. (1992). Playing games before an audience: Social facilitation or choking. Social Behavior and Personality: An International Journal, 20(2), 115–120. https://doi.org/10.2224/sbp.1992.20.2.115

\*Klaffehn, A. L., Schwarz, K. A., Kunde, W., & Pfister, R. (2018). Similar taskswitching performance of real-time strategy and first-person shooter players: Implications for cognitive training. Journal of Cognitive Enhancement, 2(3), 240– 258. https://doi.org/10.1007/s41465-018-0066-3

\*Kokkinakis, A. V, Cowling, P. I., Drachen, A., & Wade, A. R. (2017). Exploring the relationship between video game expertise and fluid intelligence. PLoS ONE, 12(11). https://doi.org/10.1371/journal.pone.0186621

Korea e-Sports Association. (2014). History of Korea e-Sports Association 1999-2004. Retrieved from https://www.theverge.com/2013/9/30/4719766/twitch-raises-20- million-esports-market-booming

\*Kowalczyk, N., Shi, F., Magnuski, M., Skorko, M., Dobrowolski, P., Kossowski, B., … Brzezicka, A. (2018). Real-time strategy video game experience and structural connectivity—A diffusion tensor imaging study. Human Brain Mapping, 39(9), 3742–3758. https://doi.org/10.1002/hbm.24208

\*Lau-Zhu, A., Holmes, E. A., Butterfield, S., & Holmes, J. (2017). Selective association between Tetris game play and visuospatial working memory: A preliminary investigation. Applied Cognitive Psychology, 31(4), 438–445. https://doi.org/10.1002/acp.3339

Lemmens, J. S., & Hendriks, S. J. F. (2016). Addictive online games: Examining the relationship between game genres and internet gaming disorder. Cyberpsychology, Behavior, and Social Networking, 19(4), 270–276. https://doi.org/10.1089/cyber.2015.0415

Li, R. (2016). Good luck have fun: The rise of eSports. New York, NY: Skyhorse Publishing.

Liberati, A., Altman, D., Tetzlaff, J., Mulrow, C., Gøtzsche, P., Ioannidis, J., … Moher, D. (2009). The PRISMA statement for reporting systematic reviews and metaanalyses of studies that evaluate health care interventions: Explanation and elaboration. Journal of Clinical Epidemiology, 62(10), e1–e34. https://doi.org/10.1016/j.jclinepi.2009.06.006

\*Lindstedt, J. K., & Gray, W. D. (2019). Distinguishing experts from novices by the mind’s hand and mind’s eye. Cognitive Psychology, 109, 1–25. https://doi.org/10.1016/j.cogpsych.2018.11.003

Maciej, B., Kosakowski, M., & Kaczmarek, L. D. (2020). Social challenge and threat predict performance and cardiovascular responses during competitive video gaming. Psychology of Sport and Exercise, 46, 101584. https://doi.org/10.1016/j.psychsport.2019.101584

\*Maglio, P. P., Wenger, M. J., & Copeland, A. M. (2008). Evidence for the role of selfpriming in epistemic action: Expertise and the effective use of memory. Acta Psychologica, 127(1), 72–88. https://doi.org/10.1016/j.actpsy.2007.02.001

Miyake, A., Friedman, N.P., Emerson, M.J., Witzki, A. H., Howerter, A., Wager, T. D. (2000). The unity and diversity of executive functions and their contributions to complex "frontal lobe" tasks: A latent variable analysis. Cognitive Psychology, 41(1), 49-100. https://doi.org/10.1006/cogp.1999.0734

\*Momi, D., Smeralda, C., Sprugnoli, G., Ferrone, S., Rossi, S., Rossi, A., … Santarnecchi, E. (2018). Acute and long-lasting cortical thickness changes following intensive first-person action videogame practice. Behavioural Brain Research, 353, 62–73. https://doi.org/10.1016/j.bbr.2018.06.013

Moola, S., Munn, Z., Tufanaru, C., Aromataris, E., Sears, K., Sfetcu, R., … Mu, P. (2017). Systematic reviews of etiology and risk. In E. Aromataris & Z. Munn (Eds.), Joanna Briggs Institute reviewer’s manual. Retrieved from https://reviewersmanual.joannabriggs.org/

Mora-Cantallops, M., & Sicilia, M.-Á. (2018). MOBA games: A literature review. Entertainment Computing, 26, 128–138. https://doi.org/10.1016/j.entcom.2018.02.005

Murphy, S. (2009). Video games, competition and exercise: A new opportunity for sport psychologists? The Sport Psychologist, 23(4), 487–503. https://doi.org/10.1123/tsp.23.4.487

Musculus, L. (2018). Do the best players “take-the-first”? Examining expertise differences in the option-generation and selection processes of young soccer players. Sport, Exercise, and Performance Psychology, 7(3), 271–283. https://doi.org/10.1037/spy0000123

Musculus, L., Ruggeri, A., Raab, M., & Lobinger, B. (2019). A developmental perspective on option generation and selection. Developmental Psychology, 55, 45–753. https://doi.org/10.1037/dev0000665

Nitsch, J. R., & Hackfort, D. (2015). Theoretical framework of performance psychology. In M. Raab, B. Lobinger, S. Hoffmann, A. Pizzera, & S. Laborde (Eds.), Performance psychology: Perception, action, cognition, and emotion (pp. 11–29). London, England: Academic Press. https://doi.org/10.1016/b978-0-12- 803377-7.00002-8

\*Okagaki, L., & Frensch, P. A. (1994). Effects of video game playing on measures of spatial performance: Gender effects in late adolescence. Journal of Applied Developmental Psychology, 15, 33–58. https://doi.org/10.1016/0193- 3973(94)90005-1

\*Oxford, J., Ponzi, D., & Geary, D. C. (2010). Hormonal responses differ when playing violent video games against an ingroup and outgroup. Evolution and Human Behavior, 31(3), 201–209. https://doi.org/10.1016/j.evolhumbehav.2009.07.002

Parshakov, P., Coates, D., & Zavertiaeva, M. (2018). Is diversity good or bad? Evidence from eSports teams analysis. Applied Economics, 50(47), 5062–5073. https://doi.org/10.1080/00036846.2018.1470315

Pedraza-Ramirez, I. (2019). Generación LoL: Entrenamiento psicológico mediante una propuesta holística con un equipo profesional de esports. Revista de Psicología Aplicada Al Deporte y El Ejercicio Físico, 4(1), 1–10. https://doi.org/10.5093/rpadef2019a3

\*Pereira, R., Wilwert, M. L., & Takase, E. (2016). Contributions of sport psychology to the competitive gaming: An experience report with a professional team of League of Legends. International Journal of Applied Psychology, 6(2), 27–30. https://doi.org/10.5923/j.ijap.20160602.01

Petticrew, M., & Roberts, H. (2008). Systematic reviews—Do they ‘work’ in informing decision-making around health inequalities? Health Economics, Policy and Law, 3(2), 197–211. https://doi.org/10.1017/s1744133108004453

\*Pilegard, C., & Mayer, R. E. (2018). Game over for Tetris as a platform for cognitive skill training. Contemporary Educational Psychology, 54, 29–41. https://doi.org/10.1016/j.cedpsych.2018.04.003

\*Pirker, J., Rattinger, A., Drachen, A., & Sifa, R. (2018). Analyzing player networks in Destiny. Entertainment Computing, 25, 71–83. https://doi.org/10.1016/j.entcom.2017.12.001

Pluss, M. A., Bennett, K. J. M., Novak, A. R., Panchuk, D., Coutts, A. J., & Fransen, J. (2019). Esports: The chess of the 21st century. Frontiers in Psychology, 10. https://doi.org/10.3389/fpsyg.2019.00156

Popper, B. (2013). Field of streams: How Twitch made video games a spectator sport. Retrieved from https://www.theverge.com/2013/9/30/4719766/twitch-raises-20- million-esports-market-booming

Powers, K. L., Brooks, P. J., Aldrich, N. J., Palladino, M. A., & Alfieri, L. (2013). Effects of video-game play on information processing: A meta-analytic investigation. Psychonomic Bulletin and Review, 20(6), 1055–1079. https://doi.org/10.3758/s13423-013-0418-z

\*Qiu, N., Ma, W., Fan, X., Zhang, Y., Li, Y., Yan, Y., … Yao, D. (2018). Rapid improvement in visual selective attention related to action video gaming experience. Frontiers in Human Neuroscience, 12. https://doi.org/10.3389/fnhum.2018.00047

Raab, M., Lobinger, B., Hoffmann, S., Pizzera, A., & Laborde, S. (2015). Performance psychology: Perception, action, cognition, and emotion. London, England:

Academic Press.

Raab, M., Masters, R. S. W., & Maxwell, J. P. (2005). Improving the “how” and “what” decisions of elite table tennis players. Human Movement Science, 24(3), 326–344. https://doi.org/10.1016/j.humov.2005.06.004

Reeves, S., Brown, B., & Laurier, E. (2009). Experts at play: Understanding skilled expertise. Games and Culture, 4(3), 205–227. https://doi.org/10.1177/1555412009339730

\*Röhlcke, S., Bäcklund, C., Sörman, D. E., & Jonsson, B. (2018). Time on task matters most in video game expertise. PLoS ONE, 13(10). https://doi.org/10.1371/journal.pone.0206555

Ruvalcaba, O., Shulze, J., Kim, A., Berzenski, S. R., & Otten, M. P. (2018). Women’s experiences in eSports: Gendered differences in peer and spectator feedback during competitive video game play. Journal of Sport & Social Issues, 42(4), 295–311. https://doi.org/10.1177/0193723518773287

Sala, G., Tatlidil, K. S., & Gobet, F. (2017). Video game training does not enhance cognitive ability: A comprehensive meta-analytic investigation. Psychological Bulletin, 144(2), 111–139. https://doi.org/10.1037/bul0000139

\*Sapienza, A., Zeng, Y., Bessi, A., Lerman, K., & Ferrara, E. (2018). Individual performance in team-based online games. Royal Society Open Science, 5(6). https://doi.org/10.1098/rsos.180329

Schmidt, R., Lee, T., Winstein, C., Wulf, G., & Zelaznik, H. (1999). Motor control and learning: A behavioral emphasis (6th ed.). Champaign, IL: Human Kinetics.

Schwarz, A. M., Schächinger, H., Adler, R. H., & Goetz, S. M. (2003). Hopelessness is associated with decreased heart rate variability during championship chess games. Psychosomatic Medicine, 65(4), 658–661.

https://doi.org/10.1097/01.PSY.0000075975.90979.2A \*Seya, Y., & Shinoda, H. (2016). Experience and training of a first person shooter (FPS) game can enhance useful field of view, working memory, and reaction time. International Journal of Affective Engineering, 15(3), 213–222. https://doi.org/10.5057/ijae.ijae-d-15-00014

Shamseer, L., Moher, D., Clarke, M., Ghersi, D., Liberati, A., Petticrew, M., … Whitlock, E. (2015). Preferred reporting items for systematic review and metaanalysis protocols (PRISMA-P) 2015 statement. British Medical Journal, 20(2), 148–160. https://doi.org/10.1186/2046-4053-4-1

\*Sibert, C., Gray, W. D., & Lindstedt, J. K. (2017). Interrogating feature learning models to discover insights into the development of human expertise in a real-time, dynamic decision-making task. Topics in Cognitive Science, 9(2), 374–394. https://doi.org/10.1111/tops.12225

Starkes, J., & Ericsson, K. A. (2003). Expert Performance in Sports: Advances in research on sport expertise. Champaign, IL, United States: Human Kinetics.

Steinkuehler, C. (2019). Esports research: Critical, empirical, and historical studies of competitive videogame play. Games and Culture. https://doi.org/10.1177/1555412019836855

\*Tafalla, R. J. (2007). Gender differences in cardiovascular reactivity and game performance related to sensory modality in violent video game play. Journal of Applied Social Psychology, 37(9), 2008–2023. https://doi.org/10.1111/j.1559- 1816.2007.00248.x

\*Tanaka, S., Ikeda, H., Kasahara, K., Kato, R., Tsubomi, H., Sugawara, S. K., … Watanabe, K. (2013). Larger right posterior parietal volume in action video game experts: A behavioral and voxel-based morphometry (VBM) study. PLoS ONE,

8(6). https://doi.org/10.1371/journal.pone.0066998

Tang, W.Y. (2018). Understanding esports from the perspective of team dynamics. The Sport Journal. Retrieved from http://thesportjournal.org/article/understandingesports-from-the-perspective-of-team-dynamics/

Tassi, P. (2012, December 20). 2012: The year of eSports. Forbes. Retrieved from https://www.forbes.com/sites/insertcoin/2012/12/20/2012-the-year-ofesports/#2174fa227e11

\*Tekofsky, S., Spronck, P., Goudbeek, M., Plaat, A., & van den Herik, J. (2015). Past our prime: A study of age and play style development in Battlefield 3. IEEE Transactions on Computational Intelligence and AI in Games, 7(3), 292–303. https://doi.org/10.1109/tciaig.2015.2393433

Tenenbaum, G., & Filho, E. (2016). Measurement considerations in performance psychology. In M. Raab, B. Lobinger, S. Hoffmann, A. Pizzera, & S. Laborde (Eds.), Performance psychology: Perception, action, cognition, and emotion (pp. 31–44). London, England: Academic Press. https://doi.org/10.1016/B978-0-12- 803377-7.00003-X

\*Terlecki, M., Newcombe, N. S., & Little, M. (2008). Durable and generalized effects of spatial experience on mental rotation: Gender differences in growth patterns. Applied Cognitive Psychology, 22, 996–1013. https://doi.org/10.1002/acp.1420 \*Thompson, J. J., Blair, M. R., Chen, L., & Henrey, A. J. (2013). Video game telemetry as a critical tool in the study of complex skill learning. PLoS ONE, 8(9). https://doi.org/10.1371/journal.pone.0075129

\*Thompson, J. J., Blair, M. R., & Henrey, A. J. (2014). Over the hill at 24: Persistent age-related cognitive-motor decline in reaction times in an ecologically valid video game task begins in early adulthood. PLoS ONE, 9(4).

https://doi.org/10.1371/journal.pone.0094215 \*Thompson, J. J., McColeman, C. M., Stepanova, E. R., & Blair, M. R. (2017). Using video game telemetry data to research motor chunking, action latencies, and complex cognitive-motor skill learning. Topics in Cognitive Science, 9(2), 467– 484. https://doi.org/10.1111/tops.12254

Thompson, J. J., Mccoleman, C. M., Blair, M. R., & Henrey, A. J. (2019). Classic motor chunking theory fails to account for behavioural diversity and speed in a complex naturalistic task. Plos One, 14(6), 1–24. https://doi.org/10.1371/journal.pone.0218251

Troubat, N., Fargeas-Gluck, M. A., Tulppo, M., & Dugué, B. (2009). The stress of chess players as a model to study the effects of psychological stimuli on physiological responses: An example of substrate oxidation and heart rate variability in man. European Journal of Applied Physiology, 105(3), 343–349. https://doi.org/10.1007/s00421-008-0908-2

Voss, M., Kramer, A., Basak, C., Prakash, R., & Roberts, B. (2010). Are expert athletes ‘expert’ in the cognitive laboratory? A meta-analytic review of cognition and sport expertise. Applied Cognitive Psychology, 24, 812–826. https://doi.org/10.1002/acp

Walton, C. C., Keegan, R. J., Martin, M., & Hallock, H. (2018). The potential role for cognitive training in sport: More research needed. Frontiers in Psychology, 9. https://doi.org/10.3389/fpsyg.2018.01121

\*Wang, H., Yang, H.-T., & Sun, C.-T. (2015). Thinking style and team competition game performance and enjoyment. IEEE Transactions on Computational Intelligence and AI in Games, 7(3), 243–254. https://doi.org/10.1109/TCIAIG.2015.2466240

Wang, P., Liu, H., Zhu, X., Meng, T., Li, H., & Zuo, X. (2016). Action video game training for healthy adults: A meta-analytic study. Frontiers in Psychology, 7. https://doi.org/10.3389/fpsyg.2016.00907

Witkowski, E. (2012). On the digital playing field. Games and Culture, 7(5), 349–374. https://doi.org/10.1177/1555412012454222

Wulf, G., & Lewthwaite, R. (2016). Optimizing performance through intrinsic motivation and attention for learning: The OPTIMAL theory of motor learning. Psychonomic Bulletin and Review, 23(5), 1382–1414. https://doi.org/10.3758/s13423-015-0999-9

\*Xia, B., Wang, H., & Zhou, R. (2017). What contributes to success in MOBA games? An empirical study of Defense of the Ancients 2. Games and Culture, 1–25. https://doi.org/10.1177/1555412017710599

Yee, N. (2006). The demographics, motivations and derived experiences of users of massively multi-user online graphical environments. Presence: Teleoperators and Virtual Environments, 15(3), 309–329. https://doi.org/doi:10.1162/pres.15.3.309

Figure captions

Figure 1. Flow diagram of the article-identification process following the Preferred Reporting Items for Systematic Review and Meta-Analysis Protocols. Figure 2. Heuristic model of esports performance, depicting the bidirectional influence of esports cognitive and in-game factors of performance. All constructs could be connected but are not display in the figure.

![](images/61dbf188461207cd72cbf901795adb2dffbb01de0504b989e0fe794f69ed5387.jpg)  
Figure1.Flow diagram of the article-identification process following the prefered reporting items for systematic review and meta-analysis protocols.

![](images/f4bc4f657a717896c1d2993233c2da8b6c2b190cd0853bdca782a620910158dc.jpg)  
Figure 2.Heuristic model of esports performance, depicting the bidirectional influence of esports cognitive and in-game factors of performance.

1256 Table 1. Esports games   

<html><body><table><tr><td>Game genrea Fighting games</td><td>Esports gameb</td><td>Release date</td><td>Tournamentsc</td><td>Participating playersd</td></tr><tr><td rowspan="7"></td><td> Super Street Fighter Series</td><td>1994</td><td>255</td><td>297</td></tr><tr><td>Guilty Gear Series*</td><td>1998</td><td>77</td><td>262</td></tr><tr><td>Street Fighter Series</td><td>1999</td><td>120</td><td>518</td></tr><tr><td> Super Smash Bros. Series</td><td>1999</td><td>3701</td><td>3452</td></tr><tr><td> Marvel vs. Capcom Series</td><td>2000</td><td>41</td><td>108</td></tr><tr><td>Tekken Series</td><td>2002</td><td>227</td><td>350</td></tr><tr><td>Killer Instinct</td><td>2013</td><td>43</td><td>120</td></tr><tr><td rowspan="5">Real-time strategy (RTS) games</td><td>Age of Empires Series*</td><td>1997</td><td>205</td><td>549</td></tr><tr><td>StarCraft: Brood War</td><td>1998</td><td>536</td><td>642</td></tr><tr><td>WarCraft II *</td><td>2002</td><td>1286</td><td>563</td></tr><tr><td>Wwrldof WarCaft</td><td>2004</td><td>115</td><td>406</td></tr><tr><td>StarCraft I*</td><td>2010</td><td>5308</td><td>1895</td></tr><tr><td rowspan="8">Shooters: First-person shooters (FPSs) and third- person shooters (TPSs)</td><td>Doom Series*</td><td>1994</td><td>7</td><td>21</td></tr><tr><td> Quake Series*</td><td>1996</td><td>769</td><td></td></tr><tr><td> Unreal Tournament Series*</td><td>1999</td><td>39</td><td>829 118</td></tr><tr><td> Call of Duty Series (CoD)*</td><td>2003</td><td>930</td><td>2919</td></tr><tr><td> Halo Series*</td><td>2004</td><td>284</td><td>887</td></tr><tr><td>Painkiller</td><td>2004</td><td>13</td><td>48</td></tr><tr><td>Battlefield Series* Rainbow Six: Vegas</td><td>2006</td><td>169</td><td>224</td></tr><tr><td></td><td>2006</td><td>7</td><td>137</td></tr><tr><td></td><td> Counter-Strike (CS)*</td><td>2000</td><td>894</td><td>3677</td></tr></table></body></html>

<html><body><table><tr><td rowspan="7">Game genrea</td><td rowspan="3">Esports gameb Counter-Strike Series Global Offensive (CS:GO)*</td><td>Release date</td><td>Tournamentsc</td><td> Participating playersd</td></tr><tr><td>2012</td><td>3870</td><td>11119</td></tr><tr><td>2006</td><td>34</td><td>182</td></tr><tr><td>Gears of War Series* CrossFire</td><td>2007</td><td>292</td><td>600</td></tr><tr><td>Team Fortress 2</td><td>2007</td><td>131</td><td>795</td></tr><tr><td>Rainbow Six: Siege</td><td>2015</td><td>58</td><td>435</td></tr><tr><td>Overwatch</td><td>2016</td><td>631</td><td>2925</td></tr><tr><td>Fortnite</td><td>2017</td><td>173</td><td>1426</td></tr><tr><td></td><td>2017</td><td>116</td><td>1319</td></tr><tr><td rowspan="3">Multiplayer online battle arenas (MOBAs)</td><td>Apex Legends</td><td>2019</td><td>6</td><td>72</td></tr><tr><td>League of Legends (LoL)*</td><td>2009</td><td>2208</td><td>6125</td></tr><tr><td>Dense f he anieats</td><td>2013</td><td>1062</td><td>2859</td></tr><tr><td rowspan="4">Sports games</td><td>Smite</td><td>2014</td><td>94</td><td>513</td></tr><tr><td>FIFA Series*</td><td>1999</td><td>879</td><td>1399</td></tr><tr><td>Madden NFL Series</td><td>2003</td><td>15</td><td>114</td></tr><tr><td></td><td>2003</td><td>36</td><td>102</td></tr><tr><td rowspan="5">Racing</td><td>Rocket League</td><td>2015</td><td>259</td><td> 502</td></tr><tr><td>NBA 2K</td><td>2017</td><td>3</td><td>78</td></tr><tr><td>TrackMania</td><td>2006</td><td>146</td><td>196</td></tr><tr><td>iRacing Project CARS</td><td>2008 2015</td><td>45 8</td><td>317</td></tr><tr><td>Flmsports sries</td><td>2017</td><td>2</td><td>19 44</td></tr></table></body></html>

<html><body><table><tr><td>Game genrea</td><td>Esports gameb</td><td>Release date</td><td>Tournamentsc</td><td> Participating playersd</td></tr><tr><td rowspan="5">Mobile</td><td>NASCAR Heat 3</td><td>2018</td><td>1</td><td>32</td></tr><tr><td>Vainglory</td><td>2014</td><td>35</td><td>247</td></tr><tr><td>Arena of Valor</td><td>2015</td><td>24</td><td>260</td></tr><tr><td> Clash Royale</td><td>2016</td><td>27</td><td>133</td></tr><tr><td> PlayerYUnkndw PUBG)</td><td>2017</td><td>6</td><td>90</td></tr><tr><td rowspan="2">Other</td><td>Tetris*</td><td>1989</td><td>7</td><td>232</td></tr><tr><td>Hearthstone</td><td>2014</td><td>821</td><td>2116</td></tr></table></body></html>

Notes. a Authors doing action video game research usually combine games from the RTS, FPS, and MOBA genres. b Games with an asterisk were found in publications included in the review. c Exact number of official tournaments could vary (taken from www.esportsearnings.com; data retrieved January 2019. d Exact number of official players of the tournaments could vary (taken from www.esportsearnings.com; data retrieved January 2019.

1267 Table 2. PICO model of the systematic review   

<html><body><table><tr><td>Population</td><td>Intervention/Phenomena</td><td>Comparators</td><td>Outcomes</td></tr><tr><td>Esports games, general healthy human population research, excludingolderadult population|performance.Weincluded|andnon-players incognitive andbehaviour from measuresofcognitive and machine modelling or artificial intelligence</td><td>Psychological aspects of cognitive and game papers that exclusively tested esports games.</td><td>(1) Expertise level (2) Differences between players game performance (3) Differences between games in cognitive and game performance.</td><td>Esports performance: (a) Cognitive performance: participants’ processes in a laboratory setting associated with esports games. (b) Game performance: winning or losing, placement in a ranking system, points scored, KDA, gold acquired per minute, etc.</td></tr></table></body></html>

1268 Note. KDA $=$ In-game kill–death–assist ratio.

1279 Table 3. Cognitive performance   

<html><body><table><tr><td>Study (first author)</td><td>Year</td><td>Esports gameb</td><td>Purpose of study</td><td>No. of participants</td><td>Study design</td><td>Cognitive function</td><td>Biological marker</td></tr><tr><td>Okagakia</td><td>1994</td><td> Tetris</td><td>Effets pgesorts</td><td>Exp 1:N=-57; Exp.</td><td> Experimental</td><td>Wm</td><td>1</td></tr><tr><td>C.S. Greena</td><td>2007</td><td>Unreal47Teamsent</td><td></td><td>Exp. 2: N= 32</td><td>Experimental</td><td>WM</td><td></td></tr><tr><td>Terlecki</td><td>2008</td><td> Tetris</td><td>Efetsfsesorss</td><td>N= 180</td><td>Experimintal</td><td>wm</td><td></td></tr><tr><td>Tanaka</td><td>2013</td><td> Guilty Gear</td><td>Expertise differences</td><td>N=50</td><td>ex perimental</td><td>WM</td><td> GM volume</td></tr><tr><td>Pereira</td><td>2016</td><td>LoL</td><td> Expertise differences</td><td> N = 5 pro players</td><td> Experimental</td><td>WM</td><td>HR</td></tr><tr><td>Chang</td><td>2017</td><td>LoL</td><td>Expertise differences</td><td>N=116</td><td>xermental</td><td>WM</td><td></td></tr><tr><td>Bonnya</td><td>2017</td><td>Dota 2</td><td>Effetsf espars</td><td>N= 288</td><td>expermiertal</td><td> WM</td><td></td></tr><tr><td>Kowalczyk</td><td>2018</td><td> StarCraft I</td><td>Expertise differences</td><td>N= 62</td><td>experimental</td><td>WM</td><td> WM structure</td></tr><tr><td>Aliyari</td><td>2015</td><td>FIFA 15</td><td></td><td>N= 32</td><td> Experimental</td><td>IC</td><td>bCortisdes</td></tr><tr><td>Qiu</td><td>2018</td><td>LoL</td><td> Expertise differences</td><td>N= 29</td><td> Experimental</td><td>IC</td><td> N1, N2, P2, P3</td></tr><tr><td>Hyun</td><td>2013</td><td>StarCraft Age of Empires II,</td><td>Expertise differences</td><td> N = 23 pro players</td><td> Experimental </td><td>CF</td><td> Cortial</td></tr><tr><td>Klaffehn</td><td></td><td>2018LLDt.cs.cao CoD, Counters-Strike</td><td></td><td>N= 1,155</td><td>expermintal</td><td>CF</td><td>1</td></tr><tr><td>C.S. Greena</td><td>2003</td><td> Tetris</td><td></td><td>Exp.5xpo: p: </td><td> Experimental</td><td> WM, IC</td><td></td></tr></table></body></html>

<html><body><table><tr><td>Study (first author)</td><td>Year</td><td>Esports gameb</td><td>Purpose of study</td><td> No. of participants</td><td> Study design</td><td>Cognitive function</td><td>Biological marker</td></tr><tr><td>C.S. Greena</td><td>2006</td><td> Tetris Unreal</td><td>Effects of esports training</td><td>Exp. 2: N= 17 Exp. control: n = 16</td><td>Experimental</td><td>WM, IC</td><td></td></tr><tr><td> Wublander</td><td>2011</td><td> Halo CSsG,O, Gears</td><td> Expertise differences</td><td>Exp.1:N=-20/Exp.</td><td>Experimental</td><td>WM, IC</td><td></td></tr><tr><td>Bavelier</td><td>2012</td><td></td><td> Expertise differences</td><td>N= 26</td><td>Experimintal</td><td>WM, IC</td><td>Fronto-warietal</td></tr><tr><td>Bowmana</td><td>2013</td><td> Quake 3</td><td></td><td> N= 62</td><td>experimintal</td><td>WM, IC</td><td></td></tr><tr><td>Gong</td><td>2016</td><td>LoL /Dota 2</td><td>Expertise differences</td><td>N= 45</td><td>experimeintal</td><td>WM, IC</td><td>SN,CEN</td></tr><tr><td>Seyaa</td><td>2016</td><td>CoD, Halo.and</td><td> Expertise differences</td><td></td><td> experimintal</td><td> WM, IC</td><td></td></tr><tr><td>Pilegarda</td><td>2018</td><td>Tetris</td><td>Effets o iegots</td><td>Study :N=17</td><td>ex perimintal</td><td>WM, IC</td><td></td></tr><tr><td>Kokkinakisa</td><td>2017</td><td> LoL,Dota 2,Desiny</td><td> Expertise differences</td><td>Study2:N-5659</td><td></td><td> WM, HO</td><td></td></tr><tr><td>Lau-Zhua</td><td>2017</td><td>Tetris</td><td></td><td>N= 46</td><td>Experimental</td><td>WM, HO</td><td></td></tr><tr><td>Rohlckea</td><td>2018</td><td> Dota 2</td><td> Expertise differences</td><td>N= 304</td><td> Cross-sectional</td><td> WM, HO</td><td></td></tr><tr><td>Dinga</td><td>2018</td><td>LoL</td><td>Expertise differences</td><td>n =10propm-prsn</td><td>Experimental</td><td>IC,CF</td><td>Freta iat</td></tr></table></body></html>

<html><body><table><tr><td>Study (first author)</td><td>Year</td><td> Esports gameb</td><td> Purpose of study</td><td> No. of participants</td><td> Study design</td><td>Cognitive function</td><td>Biological marker</td></tr><tr><td></td><td></td><td></td><td></td><td>trainees; n = 20 students Exp 2. N = 26</td><td></td><td></td><td>occipital alpha, HR,HRV, respiration rate</td></tr><tr><td>Bejjanki</td><td>2014</td><td>UnrelT4o Ccadment</td><td>Effects of esports training</td><td>perticipnts 0n- 16</td><td> experimental</td><td> IC, HO</td><td></td></tr><tr><td>Boota</td><td>2008</td><td>Tetris</td><td>Efets fiesrorts</td><td>N= 20</td><td>Longitudinal</td><td>WM.IC,</td><td></td></tr><tr><td>Momia</td><td>2018</td><td>CS:GO</td><td>Efetsoiesraris</td><td>N 29 follx-u N</td><td> experimintal</td><td>WM.CF,</td><td> Cortia </td></tr><tr><td>Glassa</td><td>2013</td><td> StarCraft I, II</td><td>Effects f esports</td><td>N= 72</td><td>Experimental</td><td></td><td></td></tr></table></body></html>

Note. Cognitive functions: $\mathrm { C F } =$ cognitive flexibility; $\mathrm { H O } =$ higher order; $\mathrm { I C } =$ inhibitory control; $\mathbf { W M } =$ working memory. Biological markers: GM volume $=$ grey matter volume; $\mathrm { H R } =$ heart rate; $\mathrm { H R V } =$ heart rate variability; N1, N2, P2, $\mathrm { P } 3 =$ event-related potentials; $\mathrm { S N } =$ salience network; $\mathrm { C E N } =$ central executive network; WM structure $=$ white matter structure. a Studies selected in both categories: cognitive and game performance.

b Full names of all games discussed in this review can be found in Table 1.

1291 Table 4. Game performance   

<html><body><table><tr><td>Studyorst</td><td>Year</td><td>Esports gameb</td><td> Purpose of study</td><td> No. of participants</td><td> Study design</td><td>Performance</td><td>Biological</td></tr><tr><td>Maglio</td><td>2008</td><td> Tetris</td><td>Expertise differences</td><td>Exp. 1-3: N= 30, 32, and 30; Exp. 4: N=15</td><td> Cross-sectional</td><td> Other</td><td>1</td></tr><tr><td>Oxford</td><td>2010</td><td> Unreal Toumament</td><td>Expertise differences</td><td>N=42</td><td>Experimental</td><td>Result</td><td>Testortsrone</td></tr><tr><td>Thompson</td><td>2013</td><td> StarCraft II</td><td> Expertise differences</td><td>N 3360: Survey:</td><td>Cross-sectional</td><td> Other</td><td></td></tr><tr><td>Thompson</td><td>2014</td><td> StarCraft II</td><td> Expertise differences</td><td>N= 3,360</td><td> Cross-sectional</td><td> Other</td><td>1</td></tr><tr><td>Tekofsky</td><td>2015</td><td> Battlefield 3</td><td> Expertise differences</td><td> N = 10,942</td><td>Crossgsutia</td><td> Other</td><td></td></tr><tr><td>Wang</td><td>2015</td><td>LoL</td><td>Expertise differences</td><td>Maip:N==5.158:</td><td>Cross-sectional</td><td>Other</td><td></td></tr><tr><td>Bonny</td><td>2016</td><td>Dota 2</td><td> Expertise differences</td><td> N = 171</td><td> experimental</td><td>Rank</td><td></td></tr><tr><td>Castaneda</td><td>2016</td><td>Dota 2</td><td>Expertise differences</td><td>N= 64</td><td>Crosriental</td><td>Rank</td><td>AOI</td></tr><tr><td>Kahn</td><td>2016</td><td>LoL</td><td> Expertise differences</td><td> N = 16,499</td><td>Cross-sectional</td><td> Other</td><td></td></tr><tr><td>Huang</td><td>2017</td><td> Halo Rrat h</td><td></td><td></td><td>Cross-sectonal</td><td>Other</td><td></td></tr><tr><td>Kokkinakisa</td><td>2017</td><td>D LoL,Dola eiel</td><td> Expertise differences</td><td>stuy2:=25659</td><td></td><td> Rank / KDA</td><td></td></tr><tr><td> Sibert</td><td>2017</td><td>Tetris</td><td> Expertise differences</td><td>N= 67</td><td> Cross-sectional</td><td>Result</td><td></td></tr><tr><td>Thompson</td><td>2017</td><td> StarCraft II</td><td> Expertise differences</td><td>N= 3,317</td><td> Cross-sectional</td><td> Other</td><td></td></tr></table></body></html>

<html><body><table><tr><td>Study Cfirst</td><td>Year</td><td>Esports gameb</td><td> Purpose of study</td><td> No. of participants</td><td> Study design</td><td> Performance</td><td>Biological</td></tr><tr><td>Xia</td><td>2017</td><td>Dota 2</td><td>Expertise differences</td><td>N= 370 pro players; n = 37 replays pro games</td><td>Cross-sectional</td><td>Other</td><td> Frontal midline</td></tr><tr><td>Dinga</td><td>2018</td><td>LoL</td><td> Expertise differences</td><td>N= 40</td><td> Experimental</td><td> Other</td><td>theta, frontal alpha asymmetry, occipital alpha, HR, HRV, respiration rate</td></tr><tr><td>Gray</td><td>2018</td><td>LoL</td><td> Expertise differences</td><td>N= 26</td><td>Experimental</td><td>Rank / KDA</td><td>Testosterone, corisol DHEA,</td></tr><tr><td>Pirker</td><td>2018</td><td>Destiny</td><td> Expertise differences</td><td> N = 10,000</td><td> Cross-sectional</td><td> Other</td><td>aldosterone</td></tr><tr><td>Rohlckea</td><td>2018</td><td>Dota 2</td><td> Expertise differences</td><td>N= 304</td><td> Cross-sectional</td><td>Rank</td><td></td></tr><tr><td> Sapienza</td><td>2018</td><td>LoL</td><td> Expertise differences</td><td>N = 16,665</td><td> Longitudinal</td><td> Other</td><td>一</td></tr><tr><td>Lindstedt</td><td>2019</td><td>Tetris</td><td> Expertise differences</td><td>N= 240</td><td> Experimental</td><td>Other</td><td></td></tr><tr><td>C.S. Greena</td><td>2003</td><td> Tetris</td><td>Efets fespotsts</td><td></td><td> Experimental</td><td> Result</td><td></td></tr><tr><td>C.S. Greena</td><td>2006</td><td>Tetris</td><td></td><td>N=17xpon8</td><td>Experimental</td><td>Result</td><td></td></tr><tr><td>Boota</td><td>2008</td><td>Tetris</td><td>Effects of esports training</td><td>n = 20</td><td> Longitudinal </td><td> Result</td><td></td></tr><tr><td>Glassa</td><td>2013</td><td> StarCraft I, I</td><td>Effetsosigsprtst</td><td>N= 72</td><td>Experimental</td><td>Other</td><td></td></tr></table></body></html>

<html><body><table><tr><td>Studyn orst</td><td>Year</td><td> Esports gameb</td><td>Purpose of study</td><td> No. of participants</td><td> Study design</td><td>Performance</td><td>Biologieal</td></tr><tr><td>Seyaa</td><td>2016</td><td>CoD Held</td><td>Effets f isgrts</td><td>N=8</td><td>experimintal</td><td> Result</td><td></td></tr><tr><td>Momia</td><td>2018</td><td>CS:G0</td><td></td><td> N= 29 folw-up N</td><td>experimintal</td><td>KDA</td><td> Cortia</td></tr><tr><td>Pilegarda</td><td>2018</td><td>Tetris</td><td>Effets fiesrorts</td><td>Study :N=17</td><td>experimintal</td><td> Result</td><td>1</td></tr><tr><td>Kimble</td><td>1992</td><td>Tetris</td><td>Effects of esports participation</td><td>N= 46</td><td>Experimental</td><td>Result</td><td></td></tr><tr><td>Okagakia</td><td>1994</td><td> Tetris</td><td>Effets p sports</td><td>Exp1:n=57:Exp</td><td> Experimental </td><td> Result</td><td></td></tr><tr><td>C.S. Greena</td><td>2007</td><td>Unreal47ourtrisent</td><td>Effectsip atsorts</td><td>Exp.2: N= 32</td><td>Experimental</td><td>KDA</td><td></td></tr><tr><td>Tafalla</td><td>2007</td><td> Doom</td><td>Effects of esports participation</td><td>N= 73</td><td> Experimental</td><td> KDA</td><td> SBP, DBP, HR</td></tr><tr><td>Billieux</td><td>2013</td><td>WoW</td><td>Effertsipgafiorts</td><td>Prestady:N=1.059;</td><td>Longitudinal</td><td>Other</td><td>一</td></tr><tr><td>Bowmana</td><td>2013</td><td> Quake 3</td><td>Effertscpgsportsrt</td><td>N= 62</td><td> ex perimintal</td><td> KDA</td><td></td></tr><tr><td>Breuer</td><td>2013</td><td>FIFA World Cup</td><td>Effartsop tforts</td><td>N= 76</td><td>Experimental</td><td>Result</td><td></td></tr><tr><td>Bertran</td><td>2016</td><td>LoL</td><td>Effects of esports participation</td><td>N= 369</td><td>Cross-sectional</td><td> KDA</td><td></td></tr><tr><td>Hudson</td><td>2016</td><td>Stwar1.Dta2,</td><td>Efferts feasports</td><td>Study 1: N = 18</td><td>Experimental</td><td>Result</td><td></td></tr><tr><td>Bonnya</td><td>2017</td><td>Dota 2</td><td>Effertsp gsports</td><td>N= 288</td><td>experimintal</td><td>Rank</td><td></td></tr><tr><td>Hopp</td><td>2017</td><td>CS:GO</td><td>Efferts feasports</td><td>Prmstmdy:N=114;</td><td>Cross-sectional</td><td>KDA</td><td></td></tr></table></body></html>

<html><body><table><tr><td>Studyorst</td><td>Year</td><td>Esports gameb</td><td> Purpose of study</td><td> No. of participants</td><td> Study design</td><td>Performance</td><td>Biologieal</td></tr><tr><td>Lau-Zhua</td><td>2017</td><td>Tetris</td><td>Efferts fatorts</td><td>N= 46</td><td>Experimental </td><td>Result</td><td></td></tr></table></body></html>

Note. $\mathbf { A O I } =$ areas of interest; $\mathrm { D B P = }$ diastolic blood pressure; DHEA $=$ dehydroepiandrosterone; $\mathrm { H R } =$ heart rate; $\mathrm { H R V } =$ heart rate variability; $\mathrm { K D A } = \mathrm { k i l l s }$ , deaths, assists; $\mathrm { S P B = }$ systolic blood pressure; Other $=$ in-game measures (e.g., hotkey usage, last hitting, earned/spent gold). a Studies selected in both categories: cognitive and game performance.

b Full names of all games discussed in this review can be found in Table 1.